<?php
/*
Plugin Name: Custom Cover Link
Description: Extends the core Cover block to add a custom link.
Version: 1.0
Author: calcs
*/

function enqueue_custom_block_editor_assets() {
    wp_enqueue_script(
        'custom-cover-link',
        plugin_dir_url(__FILE__) . 'custom-cover-link.js',
        array('wp-blocks', 'wp-element', 'wp-editor', 'wp-components', 'wp-block-editor'),
        filemtime(plugin_dir_path(__FILE__) . 'custom-cover-link.js'),
        true
    );
    wp_enqueue_style(
        'custom-cover-link-style',
        plugin_dir_url(__FILE__) . 'custom-cover-link.css',
        array(),
        filemtime(plugin_dir_path(__FILE__) . 'custom-cover-link.css')
    );
}
add_action('enqueue_block_editor_assets', 'enqueue_custom_block_editor_assets');

function enqueue_custom_block_frontend_assets() {
    wp_enqueue_style(
        'custom-cover-link-style',
        plugin_dir_url(__FILE__) . 'custom-cover-link.css',
        array(),
        filemtime(plugin_dir_path(__FILE__) . 'custom-cover-link.css')
    );
}
add_action('wp_enqueue_scripts', 'enqueue_custom_block_frontend_assets');

function add_cover_block_link( $block_content, $block ) {
    if ('core/cover' === $block['blockName'] && isset( $block['attrs']['link'] )) {
        $link = $block['attrs']['link'];
        $block_content = '<a href="' . esc_url( $link ) . '" class="cover-link">' . $block_content . '</a>';
    }

    return $block_content;
}
add_filter( 'render_block', 'add_cover_block_link', 10, 2 );