(function(wp) {
    const { registerBlockType } = wp.blocks;
    const { createHigherOrderComponent } = wp.compose;
    const { InspectorControls, RichText, BlockControls, AlignmentToolbar, __experimentalLinkControl } = wp.blockEditor;
    const { PanelBody, ToolbarButton, Popover } = wp.components;
    const { Fragment, useState, createElement } = wp.element;

    // カバーブロックの拡張
    const withCustomCoverLink = createHigherOrderComponent((BlockEdit) => {
        return (props) => {
            if (props.name !== 'core/cover') {
                return createElement(BlockEdit, props);
            }

            const { attributes: { link }, setAttributes } = props;
            const [isLinkPickerOpen, setIsLinkPickerOpen] = useState(false);

            const openLinkPicker = () => setIsLinkPickerOpen(true);
            const closeLinkPicker = () => setIsLinkPickerOpen(false);

            return createElement(
                Fragment,
                null,
                createElement(BlockEdit, props),
                createElement(
                    InspectorControls,
                    null,
                    createElement(
                        PanelBody,
                        { title: 'リンク設定' },
                        createElement(
                            ToolbarButton,
                            {
                                icon: 'admin-links',
                                label: 'リンクを編集',
                                onClick: openLinkPicker,
                            }
                        ),
                        isLinkPickerOpen && createElement(
                            Popover,
                            { position: "middle center", onClose: closeLinkPicker },
                            createElement(
                                __experimentalLinkControl,
                                {
                                    value: { url: link },
                                    onChange: (value) => setAttributes({ link: value.url }),
                                }
                            )
                        )
                    )
                )
            );
        };
    }, 'withCustomCoverLink');

    // カバーブロックの属性を拡張
    const addCustomCoverAttributes = (settings, name) => {
        if (name !== 'core/cover') {
            return settings;
        }

        settings.attributes = Object.assign(settings.attributes, {
            link: {
                type: 'string',
                default: ''
            }
        });

        return settings;
    };

    // フィルターフックに追加
    wp.hooks.addFilter(
        'editor.BlockEdit',
        'custom/with-custom-cover-link',
        withCustomCoverLink
    );

    wp.hooks.addFilter(
        'blocks.registerBlockType',
        'custom/add-custom-cover-attributes',
        addCustomCoverAttributes
    );

    // ブロック保存の修正
    const withCustomSave = (element, blockType, attributes) => {
        if (blockType.name !== 'core/cover') {
            return element;
        }

        const { link } = attributes;

        if (!link) {
            return element;
        }

        return createElement(
            'a',
            { href: link, className: 'cover-link' },
            element
        );
    };

    wp.hooks.addFilter(
        'blocks.getSaveElement',
        'custom/with-custom-save',
        withCustomSave
    );
})(window.wp);
